# This Makefile builds the sample programs in 
# $(ORACLE_HOME)/precomp/demo/procob2, and can serve as a template for linking
# customer applications.

include $(ORACLE_HOME)/precomp/lib/env_precomp.mk

# SAMPLES is a list of the procobol sample programs.
# GNTSAMPLES is the list of the .gnt files for the sample programs.
SAMPLES=sample1 sample2 sample3 sample4 sample6 sample7 sample8 \
	sample9 sample10 sample11 sample12 sample13 sample14 lobdemo1 \
	bufinsdemo db2arrdemo outlndemo stmtcache
GNTSAMPLES=sample1.gnt sample2.gnt sample3.gnt sample4.gnt \
	sample6.gnt sample7.gnt sample8.gnt sample9.gnt \
	sample10.gnt sample11.gnt sample12.gnt sample13.gnt \
	sample14.gnt lobdemo1.gnt bufinsdemo.gnt db2arrdemo.gnt \
	outlndemo.gnt stmtcache.gnt

# To create and run a dynamically loadable sample program to
# be used with the rtsora run-time system
# Eg:
        # $ make -f demo_procob.mk sample1.gnt
        # $ rtsora sample1.gnt

# These targets build all of a class of samples in one call to make.
samples: clean $(SAMPLES)
gntsamples: clean $(GNTSAMPLES)

# The target 'build' puts together an executable $(EXE) from the cobol
# sources in $(COBS) and the libraries in $(COBOL_PROLDLIBS).
# The rules to make .cob files from .pco files are later in this file.
# The target 'build_static' is similar, but does not use the client shared
# library.
build: $(COBS)
	$(DEMO_PROCOB_BUILD_SHARED)

build_static: $(COBS)
	$(DEMO_PROCOB_BUILD_STATIC)

$(SAMPLES):
	$(MAKE) -f $(MAKEFILE) build COBS=$@.cob EXE=$@

#-------------------------------------------------------------------
# Clean up all executables, *.o and generated *.cob *.gnt files
clean:
	$(SILENT)$(RMF) $(SAMPLES) $(GNTSAMPLES)
	$(SILENT)$(RMF) sample*.cob sample*.cbl SAMPLE*.COB SAMPLE*.CBL
	$(SILENT)$(RMF) sample*.int sample*.idy SAMPLE*.INT SAMPLE*.IDY
	$(SILENT)$(RMF) sample*.lis SAMPLE*.LIS
	$(SILENT)$(RMF) sample*.$(OBJ_EXT)

# Dynamically linked procobol application are built by generating .gnt files.
# The rules for .cob -> .gnt come later.

# sample5.pco illustrates the precompiler part of building a precompiler-forms
# application.  Building the actual executable would require the FORMS bundle.
# Since the controlling executable in a forms application is from forms,
# a dynamically linked procobol user-exit doesn't really make sense.
sample5:
	$(SILENT)$(ECHO) 'sample5 is a user-exit demo; use a makefile from forms.'
sample5.gnt:
	$(SILENT)$(ECHO) 'sample5 is a user-exit demo; do not make a .gnt file.'

# Some of the samples require that .sql scripts be run before precompilation.
# If you set RUNSQL=run in your call to make, then make will use sqlplus or
# svrmgrl, as appropriate, to run the .sql scripts.
# If you leave RUNSQL unset, then make will print out a reminder to run the
# scripts.
# If you have already run the scripts, then RUNSQL=done will omit the reminder.
sqlplus_run:
	($(CD) ../sql; $(BINHOME)sqlplus $(USER) @$(SCRIPT) < /dev/null)
svrmgrl_run:
	($(CD) ../sql; $(BINHOME)svrmgrl < $(SCRIPT).sql)
sqlplus_ svrmgrl_:
	$(SILENT)$(ECHO) "# You must run the .sql script, " $(SCRIPT),
	$(SILENT)$(ECHO) "# before precomping this sample."
sqlplus_done svrmgrl_done:
#
calldemo-sql:
	$(MAKE) -f $(MAKEFILE) USER=$(USERID) SCRIPT=calldemo sqlplus_$(RUNSQL)
sample11-sql:
	$(MAKE) -f $(MAKEFILE) USER=$(USERID) SCRIPT=sample11 sqlplus_$(RUNSQL)
lobdemo1-sql:
	$(MAKE) -f $(MAKEFILE) USER=$(USERID) SCRIPT=lobdemo1 sqlplus_$(RUNSQL)

# Here are some rules for converting .pco -> .cob -> .o and for .cob -> .gnt.
.SUFFIXES: .cob .cbl .o .pco $(GNT)

.pco.cob:
	$(PROCOB) $(PCCFLAGS) iname=$*.pco

.cob$(GNT):
	$(COB2GNT)

# These are specific targets to make the .o files for samples that require
# more careful handling.
sample9.cob: calldemo-sql
	$(PROCOB) $(PCCPLSFLAGS) iname=$*.pco 
sample11.cob: sample11-sql
	$(PROCOB) $(PCCPLSFLAGS) iname=$*.pco 
lobdemo1.cob: lobdemo1-sql
	$(PROCOB) $(PCCPLSFLAGS) iname=$*.pco 
sample12.cob: sample12.pco
	$(PROCOB) dynamic=ansi iname=$*.pco
bufinsdemo.cob: bufinsdemo.pco
	$(PROCOB) max_row_insert=100 iname=$*.pco
db2arrdemo.cob: db2arrdemo.pco
	$(PROCOB) db2_array=yes iname=$*.pco
outlndemo.cob: outlndemo.pco
	$(PROCOB) $(PCCPLSFLAGS) outline=yes runoutline=yes outlnprefix=outprefix iname=$*.pco
stmtcache.cob: stmtcache.pco
	$(PROCOB) stmt_cache=20 iname=$*.pco

# These macro definitions fill in some details or override some defaults
MAKEFILE=$(ORACLE_HOME)/precomp/demo/procob2/demo_procob.mk
PCCPLSFLAGS=sqlcheck=full userid=$(USERID) picx=varchar2
USERID=scott/tiger
